<?php
/**
 * This file will handle "unsubcribe" action that is instigated by subscribers.
 *
 *
 * @todo refactor
 */

// Include common procedure.
defined('IEM_UNSUBSCRIBE_HACK') or define('IEM_UNSUBSCRIBE_HACK', true);
require_once dirname(__FILE__) . '/unsubscribe_common.php';

defined('SENDSTUDIO_USEMULTIPLEUNSUBSCRIBE') or define('SENDSTUDIO_USEMULTIPLEUNSUBSCRIBE', '0');

$tpl = GetTemplateSystem();

$GLOBALS['unsubscribe_link'] = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

$subinfo = $subscriberapi->LoadSubscriberList($subscriber_id, $_GET['L'], false, false, true);

if (!SENDSTUDIO_USEMULTIPLEUNSUBSCRIBE) {
    if ($_SERVER['REQUEST_METHOD'] == "POST") {
        require_once dirname(__FILE__) . '/unsubscribe_confirmed.php';
        exit();
    } elseif (isset($subinfo['unsubscribed']) && $subinfo['unsubscribed'] > 0) {
        $listload = $listapi->Load($subinfo['listid']);
        $listname = $listapi->Get('name');
        $GLOBALS['DisplayMessage'] = sprintf(GetLang('UnsubscribeFail_AlreadyUnsubscribed'), $listname);
        $sendstudio_functions->ParseTemplate('Default_Form_Message', false, true, '');
        exit();
    } elseif (isset($_GET['opt_out']) && $_GET['opt_out'] != $subinfo['unsubscribecode']) {
        $GLOBALS['DisplayMessage'] = GetLang('InvalidUnsubscribeURL');
        $sendstudio_functions->ParseTemplate('Default_Form_Message', false, true, '');
        exit();
    } elseif (isset($_GET['opt_out']) && !empty($subinfo['unsubscribecode']) && $_GET['opt_out'] == $subinfo['unsubscribecode']) {
        require_once dirname(__FILE__) . '/unsubscribe_confirmed.php';
        exit();
    } else {
        $unsubscribe_code = $subinfo['unsubscribecode'] ?? NULL;
        if (empty($unsubscribe_code)) { //if there is no unsubscribecode in the db
            $unsubscribe_code = $subscriberapi->UpdateSubscriberUnsubscribeCode($subscriber_id); // call this function, generate new code and update unsubscribeconfirm code
        }

        $tpl->Assign('UnsubscriptionConfirmText', sprintf(GetLang('UnsubscriptionConfirmText'), $subinfo['emailaddress'] ?? ''));
        $tpl->Assign('unsubscribecode', $unsubscribe_code);
        echo $tpl->ParseTemplate('unsubscribe_confirm_form', true, '');
        exit();
    }
}

$primary_listid = 0;
if (isset($foundparts['l'])) {
    $primary_listid = $foundparts['l'];
}

if (isset($foundparts['a'])) {
    $statstype = 'auto';
    $statid = $foundparts['a'];
} elseif (isset($foundparts['n'])) {
    $statstype = 'newsletter';
    $statid = $foundparts['n'];
}
$validLists = [];
if ($statstype) {
    $validLists = $subscriberapi->GetSubscribersListByStatOwner($statid, $subscriber_id, $statstype);
} elseif ($primary_listid > 0) {
    // default
    $validLists[] = ['listid' => $primary_listid, 'subscriberid' => $subscriber_id];
}

if ($primary_listid <= 0 && $subscriber_id > 0) {
    //get all lists for subscriber
    $subscriber_email = $subscriberapi->GetEmailForSubscriber($subscriber_id);
    $db = IEM::getDatabase();
    $subscriber_email = $db->Quote($subscriber_email);
    $result = $db->query("SELECT listid FROM [|PREFIX|]list_subscribers WHERE emailaddress = '{$subscriber_email}'");
    while ($row = $db->Fetch($result)) {
        $all_lists[] = $row['listid'];
    }
    if (!empty($all_lists)) {
        foreach ($all_lists as $lid) {
            $validLists[] = ['listid' => $lid, 'subscriberid' => $subscriber_id];
        }
    }
}

$displayList = [];
foreach ($validLists as $eachList) {
    if ($eachList['listid'] <= 0) {
        continue;
    }
    $listapi->Load($eachList['listid']);
    $subscriberlistinfo = $subscriberapi->LoadSubscriberList($eachList['subscriberid'], $eachList['listid'], false, false, true);
    $displayList[] = ['listid' => $eachList['listid'], 'name' => $listapi->Get('name'), 'cc' => $subscriberlistinfo['confirmcode'], 'subscriberid' => $eachList['subscriberid']];
}
if (!sizeof($displayList)) {
    $GLOBALS['DisplayMessage'] = GetLang('DefaultUnsubscribeMessage');
    $sendstudio_functions->ParseTemplate('Default_Form_Message', false, true, '');
    exit();
}

$GLOBALS['Message'] = '<div style="padding:10px;">' . GetLang('Unsubscribe_Form_Note') . '</div>';

$tpl->Assign('page', $_GET);
$tpl->Assign('list', $displayList);
$tpl->Assign('primary_listid', $primary_listid);
echo $tpl->ParseTemplate('unsubscribe_form', true, '');
