<?php
/**
 * This is the api file for mta rotations to use.
 * It allows you to create, update, delete, load a mta rotation.
 *
 * @package SendStudio
 * @subpackage FolderView
 */

/**
 * This is the mta rotations api class.
 * It handles all of the database stuff (creating/loading/updating/searching).
 *
 * @uses IEM::getDatabase()
 *
 * @package SendStudio
 * @subpackage FolderView
 */
require_once('functions/folders.php');
require_once(dirname(__FILE__) . '/api.php');
class FolderView_API extends API
{
	/**
	 * $db
	 * A local database connection
	 *
	 * @see __construct
	 */
	private $db;
	private $tpl;
	public $_PerPageDefault = 10;
	/**
	 * __construct
	 * Sets up the database connection for easy use.
	 *
	 * @uses IEM::getDatabase()
	 * @see db
	 */
	public function __construct()
	{
		$this->db = IEM::getDatabase();
		$this->tpl = GetTemplateSystem();
	}
	
	public function setFolderMode(){
		$folders = new Folders();
		
		if (isset($_GET['Mode'])) {
			 
			$folders->SetFolderMode(strtolower($_GET['Mode']));
		}
		unset($folders);
	}
	
	public function manageFolder($type){
		$folders = new Folders();
		   
		 if ($folders->InFolderMode()) {
			 
			$perpage = 'all';
			$GLOBALS['Mode'] = 'Folder';
			$GLOBALS['Type'] = $type;
		 } else {
			 $perpage = $this->GetPerPage($type);
			 $GLOBALS['Mode'] = 'List';
		 }
		return $perpage;
	}
	
	public function manageRowsFolders($type, $dataRecords, $data_manage, $paging_bottom, $data_display, $paging){
		$folders = new Folders();
		
		if(strtolower($type) == "campaign"){
			$pageName = "TPL_Newsletters_Manage_Row";
		}else if(strtolower($type) == "autoresponder"){
			$pageName = "TPL_Autoresponders_Manage_Row";
		}else{
			$pageName = "TPL_Newsletters_Manage_Row";
		}
		   
		 if ($folders->InFolderMode()) {
			   
			$user = IEM::userGetCurrent();
			// Organise the rows into their respective folders.
			$folder_type = $type; //'campaign';
			$folders_api = $this->GetApi('Folders');
			$sortinfo = [];
			$folder_list = $folders_api->GetFolderList($folder_type, $user->Get('userid'), $sortinfo);
 
			// Folder ID 0 is special -- it's the 'Uncategorised' or 'Orphan' folder.
			$folder_list[0]['name'] = GetLang('Folders_OrphanName');
 
			// Accumulate the HTML for each folder and list.
			$f_html = '';
			$orphan_html = '';
			$check = 1;
			foreach ($folder_list as $fid=>$folder) {
				$l_html = '';
				
				if (is_array($folder['items'])) {
					// Loop through $lists, as these will be sorted for us already.
					 
					foreach ($dataRecords as $lid=>$list) {
						if (in_array($lid, $folder['items'])) {
							$l_html .= $list;
						}
					}
					 
				}
				
				$GLOBALS['Items'] = $l_html;
				$GLOBALS['FolderID'] = $fid;
				$GLOBALS['FolderName'] = htmlspecialchars($folder['name']);
				$GLOBALS['FolderName_Encoded'] = urlencode($folder['name']);
				$GLOBALS['FolderType'] = $folder_type; 
			
				$GLOBALS['Expanded'] = $folder['expanded'];
				if ($fid == 0) {
					if (!$folders->IsOrphanExpanded($folder_type)) {
						$GLOBALS['Expanded'] = 0;
					}
					$orphan_html .= $this->tpl->ParseTemplate('Folder', true, false);
					continue;
				}
				$f_html .= $this->tpl->ParseTemplate('Folder', true, false);
			}
			// The orphan folder should be put at the end
			
			$f_html .= $orphan_html;
			$data_manage = str_replace('%%'.$pageName.'%%', $f_html, $data_manage);
			$data_manage = str_replace('%%TPL_Paging%%', '', $data_manage);
			$data_manage = str_replace('%%TPL_Paging_Bottom%%', '', $data_manage);
 
		  } else {
			$data_manage = str_replace('%%'.$pageName.'%%', $data_display, $data_manage);
			$data_manage = str_replace('%%TPL_Paging%%', $paging, $data_manage);
			$data_manage = str_replace('%%TPL_Paging_Bottom%%', $paging_bottom, $data_manage);
		}  
		return $data_manage;
	}
	/**
	 * GetApi
	 * An easy way to include the folderview api file which does all of the database queries.
	 * This is marked as protected so the sub-classes (for sending & stats) can use it.
	 *
	 * @param String $api Which api to get. It defaults to the 'folderview' api but can be passed 'folderview_send' to get that api instead.
	 *
	 * @return Object|False Returns false if the api name is invalid. Otherwise returns the appropriate api object ready for use.
	 */
	protected function GetApi($api='FolderView')
	{
		if(is_array($api) && count($api) > 0){
			$api = $api[0];
		}
		$path = SENDSTUDIO_API_DIRECTORY . '/'.strtolower($api) . '.php';
		 
		if (!is_file($path)) {
			$path = SENDSTUDIO_API_DIRECTORY . '/'. strtolower($api) . '.php';
			if (!is_file($path)) {
				return false;
			}
		}

		require_once $path;
		$class = $api . '_API';
		$api = new $class;
		return $api;
	}
	/**
	* GetPerPage
	* Gets the number to show based on your session. If you don't have a session, it sets a default of this->_PerPageDefault
	*
	* @see _PerPageDefault
	* @see User_API::GetSettings
	*
	* @return Mixed Number to show per page.
	*/
	function GetPerPage($page = null)
	{
    	$user = IEM::getCurrentUser();
		$display_settings = $user->GetSettings('DisplaySettings');
		if ($page == null) {
			$page = $this->GetPageName();
            $page = strtolower($page);
		}
		
		$page = 'newsletters';
		
		if (!isset($display_settings['NumberToShow'][$page])) {
			$perpage = $this->_PerPageDefault;
		} else {
			$perpage = $display_settings['NumberToShow'][$page];
		}
		if ($perpage == 'all') {
			return $perpage;
		}
		return (int)$perpage;
	}
	
	/**
	* GetPageName
	* Used in remembering each section's paging settings.
	*
	* @see GetPerPage
	* @see SetPerPage
	*
	* @return String The name of the page/section in lower case, e.g. 'subscribers' or 'unknown' if not found.
	*/
	function GetPageName()
	{
		$page = IEM::requestGetGET('Page', '');
		if (empty($page)) {
			$page = IEM::requestGetGET('page', 'unknown');
		} else {
			$page = strtolower($page);
		}

		$action = IEM::requestGetGET('Action', IEM::requestGetGET('action', false));

		if ($action == 'ProcessPaging' && isset($_GET['SubAction'])) {
			$action = strtolower($_GET['SubAction']);
		}

		if ($page == 'stats' && !$action) {
			$action = 'newsletters';
		}

		// see bugid:2195 for why we handle this special case with subscribers
		if ($page == 'stats' || ($page == 'subscribers' && $action == 'banned')) {
			$page .= '_'.$action;
		}

		return $page;
	}
}