<script>
	function UnInstall(addon_name) {
		alpineConfirm('%%LNG_Addon_Uninstall_Confirm%%', '', 'OK', 'Cancel', 
			function() {
				document.location = 'index.php?Page=Settings&Tab=4&Action=Addons&SubAction=Uninstall&Addon=' + escape(addon_name);
			}
		);

		return true;
	}
</script>
<table cellspacing="0" cellpadding="2" width="100%" class="Panel" border="0">
	<tr class="Heading3">
		<td>{$lang.Addon_Name}</td>
		<td>{$lang.Addon_Description}</td>
		<td>{$lang.Addon_RunningVersion}</td>
		<td style="text-align: center;">{$lang.Addon_Installed}</td>
		<td style="text-align: center;">{$lang.Addon_Enabled}</td>
		<td>{$lang.Action}</td>
	</tr>
	{foreach from=$records key=addon_name item=record}
		<tr class="GridRow">
			<td><span>{$record.name}</span></td>
			<td><span title="{$record.description}">{$record.short_description}</span></td>
			<td>{$record.addon_version}</td>
			<td style="text-align: center;">
				{if $record.install_details.installed}
					<a href="#" onClick="UnInstall('{$addon_name}');" title="{$lang.Addon_Tooltip_ClickToUninstall}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-green-400">
								<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{else}
					<a href="index.php?Page=Settings&Action=Addons&Addon={$addon_name}&SubAction=install" title="{$lang.Addon_Tooltip_ClickToInstall}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-red-400">
								<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{/if}
			</td>
			<td style="text-align: center;" class="align-center justify-center">
				{if $record.install_details.enabled}
					<a href="index.php?Page=Settings&Action=Addons&Addon={$addon_name}&SubAction=disable" title="{$lang.Addon_Tooltip_ClickToDisable}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-green-400">
								<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{elseif $record.install_details.configured}
					<a href="index.php?Page=Settings&Action=Addons&Addon={$addon_name}&SubAction=enable" title="{$lang.Addon_Tooltip_ClickToEnable}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-red-400">
								<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{elseif $record.install_details}
					<a href="#" onClick="alpineAlert('{$lang.Addon_Alert_NeedToConfigure}'); return false;" title="{$lang.Addon_Tooltip_ClickToEnable}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-red-400">
								<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{else}
					<a href="#" onClick="alpineAlert('{$lang.Addon_Alert_NeedToInstall}'); return false;" title="{$lang.Addon_Tooltip_ClickToEnable}">
						<div class="flex justify-center items-center w-auto">
							<div class=" w-5 text-red-400">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
									<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
							  	</svg>
							</div>
						</div>
					</a>
				{/if}
			</td>
			<td>
				{if $record.install_details && $record.need_upgrade}
					<a href="index.php?Page=Settings&Action=Addons&Addon={$addon_name}&SubAction=upgrade">{$lang.Addon_Action_Text_Upgrade}</a>
				{elseif $record.install_details && $record.hasconfiguration}
					<a href="#" onClick="LoadAddonSettings('{$addon_name}', '{$record.name}'); return false;">{$lang.Addon_Action_Text_Configure}</a>
				{elseif $record.install_details}
					<a href="#" onClick="alpineAlert('{$lang.Addon_Alert_NoConfiguration}'); return false;" style="color:#cacaca;">{$lang.Addon_Action_Text_Configure}</a>
				{else}
					<span style="color:#cacaca;">{$lang.Addon_Action_Text_Configure}</span>
				{/if}
			</td>
		</tr>
	{/foreach}
</table>
<div id="addon_settings"></div>
