<?php
/**
 *
 * @todo all
 *
 */
class IEM_baseRecord
{
	/**
	 * @var Array $properties
	 */
	protected $properties = [];

	/**
	 * @var Array $data
	 */
	protected $data = [];

	/**
	 * @param Int|String $property
	 * @param Mixed $value
	 * 
	 * @return Void
	 */
	public function __set($property, $value)
	{
		if (!array_key_exists($property, $this->properties)) {
			trigger_error(__CLASS__ . '::' . __METHOD__ . " -- Specified property '{$property}' does not exists", E_USER_ERROR);
		}

		$this->data[$property] = $value;
	}

	/**
	 * @param Int|String $property
	 * 
	 * @return Mixed
	 */
	public function __get($property)
	{
		if (!array_key_exists($property, $this->properties)) {
			trigger_error(__CLASS__ . '::' . __METHOD__ . " -- Specified property '{$property}' does not exists", E_USER_ERROR);
		}

		return $this->data[$property];
	}

	/**
	 * @param Array $values
	 */
	public function __construct($values = [])
	{
		$this->data = [];

		foreach ($this->properties as $property => $data) {
			$this->data[$property] = (array_key_exists($property, $values) ? $values[$property] : $data);
		}
	}

	/**
	 * @return Mixed
	 */
	public function getPropertyList()
	{
		static $cache = null;

		if (is_null($cache)) {
			$cache = array_keys($this->properties);
		}

		return $cache;
	}

	/**
	 * @return Array
	 */
	public function getAssociativeArray()
	{
		return $this->data;
	}
}
