<?php

class Addons_surveys_build extends Addons_surveys
{
	/**
	 * @var IEM_InterspireTemplate $_template
	 */
	private $_template;

	/**
	 * @param IEM_InterspireTemplate $template
	 */
	public function __construct($template)	{
		$this->addon_id = 'surveys';
		parent::__construct();
		$this->_template = $template;
	}

	/**
	 * @return Never
	 */
	public function checkboxAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetCheckboxDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetCheckboxDefaultDescription'),
				'is_visible'  => 1
			]);
		$this->_template->Assign('widgetFields', [
				'0' => [
						'value' => GetLang('Addon_Surveys_WidgetValueField') . '1'
					]
			]);

		echo $this->getTemplate('checkbox');
		exit;
	}

	/**
	 * @return Never
	 */
	public function fileAction()
	{
		$this->_template->Assign('widget', [
				'name'               => GetLang('Addon_Surveys_WidgetFileDefaultName'),
				'description'        => GetLang('Addon_Surveys_WidgetFileDefaultDescription'),
				'allowed_file_types' => GetLang('Addon_Surveys_WidgetFileValueAllowedFileTypes'),
				'is_visible'         => 1
			]);

		echo $this->getTemplate('file');
		exit;
	}

	/**
	 * @return Never
	 */
	public function radioAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetRadioDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetRadioDefaultDescription'),
				'is_visible'  => 1
			]);
		$this->_template->Assign('widgetFields', [
				'0' => [
						'value' => GetLang('Addon_Surveys_WidgetValueField') . '1'
					]
			]);

		echo $this->getTemplate('radio');
		exit;
	}

	/**
	 * @return Never
	 */
	public function sectionBreakAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetSectionBreakDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetSectionBreakDefaultDescription')
			]);

		echo $this->getTemplate('section.break');
		exit;
	}

	/**
	 * @return Never
	 */
	public function selectAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetSelectDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetSelectDefaultDescription'),
				'is_visible'  => 1
			]);
		$this->_template->Assign('widgetFields', [
				'0' => [
						'value' => GetLang('Addon_Surveys_WidgetValueField') . '1'
					]
			]);

		echo $this->getTemplate('select');
		exit;
	}

	/**
	 * @return Never
	 */
	public function selectCountryAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetSelectDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetSelectDefaultDescription'),
				'is_visible'  => 1
			]);
		$this->_template->Assign('widgetFields', [
				'0'   => ['value' => 'Afghanistan'],
				'1'   => ['value' => 'Albania'],
				'2'   => ['value' => 'Algeria'],
				'3'   => ['value' => 'Andorra'],
				'4'   => ['value' => 'Angola'],
				'5'   => ['value' => 'Antigua and Barbuda'],
				'6'   => ['value' => 'Argentina'],
				'7'   => ['value' => 'Armenia'],
				'8'   => ['value' => 'Australia'],
				'9'   => ['value' => 'Austria'],
				'10'  => ['value' => 'Azerbaijan'],
				'11'  => ['value' => 'Bahamas'],
				'12'  => ['value' => 'Bahrain'],
				'13'  => ['value' => 'Bangladesh'],
				'14'  => ['value' => 'Barbados'],
				'15'  => ['value' => 'Belarus'],
				'16'  => ['value' => 'Belgium'],
				'17'  => ['value' => 'Belize'],
				'18'  => ['value' => 'Benin'],
				'19'  => ['value' => 'Bhutan'],
				'20'  => ['value' => 'Bolivia'],
				'21'  => ['value' => 'Bosnia and Herzegovina'],
				'22'  => ['value' => 'Botswana'],
				'23'  => ['value' => 'Brazil'],
				'24'  => ['value' => 'Brunei'],
				'25'  => ['value' => 'Bulgaria'],
				'26'  => ['value' => 'Burkina Faso'],
				'27'  => ['value' => 'Burundi'],
				'28'  => ['value' => 'Cambodia'],
				'29'  => ['value' => 'Cameroon'],
				'30'  => ['value' => 'Canada'],
				'31'  => ['value' => 'Cape Verde'],
				'32'  => ['value' => 'Central African Republic'],
				'33'  => ['value' => 'Chad'],
				'34'  => ['value' => 'Chile'],
				'35'  => ['value' => 'China'],
				'36'  => ['value' => 'Colombi'],
				'37'  => ['value' => 'Comoros'],
				'38'  => ['value' => 'Congo (Brazzaville)'],
				'39'  => ['value' => 'Congo'],
				'40'  => ['value' => 'Costa Rica'],
				'41'  => ['value' => 'Cote d\'Ivoire'],
				'42'  => ['value' => 'Croatia'],
				'43'  => ['value' => 'Cuba'],
				'44'  => ['value' => 'Cyprus'],
				'45'  => ['value' => 'Czech Republic'],
				'46'  => ['value' => 'Denmark'],
				'47'  => ['value' => 'Djibouti'],
				'48'  => ['value' => 'Dominica'],
				'49'  => ['value' => 'Dominican Republic'],
				'50'  => ['value' => 'East Timor (Timor Timur)'],
				'51'  => ['value' => 'Ecuador'],
				'52'  => ['value' => 'Egypt'],
				'53'  => ['value' => 'El Salvador'],
				'54'  => ['value' => 'Equatorial Guinea'],
				'55'  => ['value' => 'Eritrea'],
				'56'  => ['value' => 'Estonia'],
				'57'  => ['value' => 'Ethiopia'],
				'58'  => ['value' => 'Fiji'],
				'59'  => ['value' => 'Finland'],
				'60'  => ['value' => 'France'],
				'61'  => ['value' => 'Gabon'],
				'62'  => ['value' => 'Gambia, The'],
				'63'  => ['value' => 'Georgia'],
				'64'  => ['value' => 'Germany'],
				'65'  => ['value' => 'Ghana'],
				'66'  => ['value' => 'Greece'],
				'67'  => ['value' => 'Grenada'],
				'68'  => ['value' => 'Guatemala'],
				'69'  => ['value' => 'Guinea'],
				'70'  => ['value' => 'Guinea-Bissau'],
				'71'  => ['value' => 'Guyana'],
				'72'  => ['value' => 'Haiti'],
				'73'  => ['value' => 'Honduras'],
				'74'  => ['value' => 'Hungary'],
				'75'  => ['value' => 'Iceland'],
				'76'  => ['value' => 'India'],
				'77'  => ['value' => 'Indonesia'],
				'78'  => ['value' => 'Iran'],
				'79'  => ['value' => 'Iraq'],
				'80'  => ['value' => 'Ireland'],
				'81'  => ['value' => 'Israel'],
				'82'  => ['value' => 'Italy'],
				'83'  => ['value' => 'Jamaica'],
				'84'  => ['value' => 'Japan'],
				'85'  => ['value' => 'Jordan'],
				'86'  => ['value' => 'Kazakhstan'],
				'87'  => ['value' => 'Kenya'],
				'88'  => ['value' => 'Kiribati'],
				'89'  => ['value' => 'Korea, North'],
				'90'  => ['value' => 'Korea, South'],
				'91'  => ['value' => 'Kuwait'],
				'92'  => ['value' => 'Kyrgyzstan'],
				'93'  => ['value' => 'Laos'],
				'94'  => ['value' => 'Latvia'],
				'95'  => ['value' => 'Lebanon'],
				'96'  => ['value' => 'Lesotho'],
				'97'  => ['value' => 'Liberia'],
				'98'  => ['value' => 'Libya'],
				'99'  => ['value' => 'Liechtenstein'],
				'100' => ['value' => 'Lithuania'],
				'101' => ['value' => 'Luxembourg'],
				'102' => ['value' => 'Macedonia'],
				'103' => ['value' => 'Madagascar'],
				'104' => ['value' => 'Malawi'],
				'105' => ['value' => 'Malaysia'],
				'106' => ['value' => 'Maldives'],
				'107' => ['value' => 'Mali'],
				'108' => ['value' => 'Malta'],
				'109' => ['value' => 'Marshall Islands'],
				'110' => ['value' => 'Mauritania'],
				'111' => ['value' => 'Mauritius'],
				'112' => ['value' => 'Mexico'],
				'113' => ['value' => 'Micronesia'],
				'114' => ['value' => 'Moldova'],
				'115' => ['value' => 'Monaco'],
				'116' => ['value' => 'Mongolia'],
				'117' => ['value' => 'Morocco'],
				'118' => ['value' => 'Mozambique'],
				'119' => ['value' => 'Myanmar'],
				'120' => ['value' => 'Namibia'],
				'121' => ['value' => 'Nauru'],
				'122' => ['value' => 'Nepa'],
				'123' => ['value' => 'Netherlands'],
				'124' => ['value' => 'New Zealand'],
				'125' => ['value' => 'Nicaragua'],
				'126' => ['value' => 'Niger'],
				'127' => ['value' => 'Nigeria'],
				'128' => ['value' => 'Norway'],
				'129' => ['value' => 'Oman'],
				'130' => ['value' => 'Pakistan'],
				'131' => ['value' => 'Palau'],
				'132' => ['value' => 'Panama'],
				'133' => ['value' => 'Papua New Guinea'],
				'134' => ['value' => 'Paraguay'],
				'135' => ['value' => 'Peru'],
				'136' => ['value' => 'Philippines'],
				'137' => ['value' => 'Poland'],
				'138' => ['value' => 'Portugal'],
				'139' => ['value' => 'Qatar'],
				'140' => ['value' => 'Romania'],
				'141' => ['value' => 'Russia'],
				'142' => ['value' => 'Rwanda'],
				'143' => ['value' => 'Saint Kitts and Nevis'],
				'144' => ['value' => 'Saint Lucia'],
				'145' => ['value' => 'Saint Vincent'],
				'146' => ['value' => 'Samoa'],
				'147' => ['value' => 'San Marino'],
				'148' => ['value' => 'Sao Tome and Principe'],
				'149' => ['value' => 'Saudi Arabia'],
				'150' => ['value' => 'Senegal'],
				'151' => ['value' => 'Serbia and Montenegro'],
				'152' => ['value' => 'Seychelles'],
				'153' => ['value' => 'Sierra Leone'],
				'154' => ['value' => 'Singapore'],
				'155' => ['value' => 'Slovakia'],
				'156' => ['value' => 'Slovenia'],
				'157' => ['value' => 'Solomon Islands'],
				'158' => ['value' => 'Somalia'],
				'159' => ['value' => 'South Africa'],
				'160' => ['value' => 'Spain'],
				'161' => ['value' => 'Sri Lanka'],
				'162' => ['value' => 'Sudan'],
				'163' => ['value' => 'Suriname'],
				'164' => ['value' => 'Swaziland'],
				'165' => ['value' => 'Sweden'],
				'166' => ['value' => 'Switzerland'],
				'167' => ['value' => 'Syria'],
				'168' => ['value' => 'Taiwan'],
				'169' => ['value' => 'Tajikistan'],
				'170' => ['value' => 'Tanzania'],
				'171' => ['value' => 'Thailand'],
				'172' => ['value' => 'Togo'],
				'173' => ['value' => 'Tonga'],
				'174' => ['value' => 'Trinidad and Tobago'],
				'175' => ['value' => 'Tunisia'],
				'176' => ['value' => 'Turkey'],
				'177' => ['value' => 'Turkmenistan'],
				'178' => ['value' => 'Tuvalu'],
				'179' => ['value' => 'Uganda'],
				'180' => ['value' => 'Ukraine'],
				'181' => ['value' => 'United Arab Emirates'],
				'182' => ['value' => 'United Kingdom'],
				'183' => ['value' => 'United States'],
				'184' => ['value' => 'Uruguay'],
				'185' => ['value' => 'Uzbekistan'],
				'186' => ['value' => 'Vanuatu'],
				'187' => ['value' => 'Vatican City'],
				'188' => ['value' => 'Venezuela'],
				'189' => ['value' => 'Vietnam'],
				'190' => ['value' => 'Yemen'],
				'191' => ['value' => 'Zambia'],
				'192' => ['value' => 'Zimbabwe']
			]);

		echo $this->getTemplate('select');
		exit;
	}

	/**
	 * @return Never
	 */
	public function textAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetTextDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetTextDefaultDescription'),
				'is_visible'  => 1
			]);

		echo $this->getTemplate('text');
		exit;
	}

	/**
	 * @return Never
	 */
	public function textareaAction()
	{
		$this->_template->Assign('widget', [
				'name'        => GetLang('Addon_Surveys_WidgetTextareaDefaultName'),
				'description' => GetLang('Addon_Surveys_WidgetTextareaDefaultDescription'),
				'is_visible'  => 1
			]);

		echo $this->getTemplate('textarea');
		exit;
	}


	/**
	 * @param String $type
	 * 
	 * @return String|False
	 */
	public function getTemplate($type)
	{
		$this->_template->Assign('randomId', 'widget_' . md5(microtime()));

		$arr = [
				//'id'   => iwp_engine::getParam('id'),
				'html' => $this->_template->ParseTemplate('widget.' . $type, true)
			];

		return json_encode($arr);
	}
}