<?php

// an array of tables that are created.
// we need this so if the addon is uninstalled, we know what we need to clean up.
$tables = ['surveys', 'surveys_fields', 'surveys_widgets', 'surveys_response', 'surveys_response_value'];

// the actual queries we're going to run.
$queries = [];

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%surveys (
  	id INT(11) unsigned NOT NULL auto_increment PRIMARY KEY,
  	userid INT(11) DEFAULT 0 REFERENCES %%TABLEPREFIX%%users(userid),
	name tinytext,
  	description text,
  	created INT(11) NOT NULL,
  	updated INT(11) default NULL,

  	surveys_header enum(\'headertext\',\'headerlogo\') NOT NULL default \'headertext\',
	surveys_header_text varchar(255) NOT NULL,
	surveys_header_logo varchar(255) NOT NULL,

	email varchar(255) NOT NULL,
  	email_feedback tinyint(1) unsigned NOT NULL default 0,
  	after_submit enum(\'show_message\',\'show_uri\') NOT NULL default \'show_message\',
  	show_message text NOT NULL,
  	show_uri text NOT NULL,
  	error_message text NOT NULL,
	expiration_date INT(11) default 0,
  	submit_button_text tinytext NOT NULL
) CHARACTER SET=utf8mb4 ENGINE=INNODB';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%surveys_fields (
	id INT(11) unsigned NOT NULL auto_increment PRIMARY KEY,
	surveys_widget_id INT(11) unsigned NOT NULL default 0,
	value text,
	is_selected tinyint(1) unsigned NOT NULL default 0,
	is_other tinyint(1) unsigned NOT NULL default 0,
	other_label_text tinytext NOT NULL,
	display_order INT(11) unsigned NOT NULL default 0,
	KEY surveys_widget_id (surveys_widget_id)
) CHARACTER SET=utf8mb4 ENGINE=INNODB';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%surveys_widgets (
  	id INT(11) unsigned NOT NULL auto_increment PRIMARY KEY,
  	surveys_id INT(11) unsigned NOT NULL default 0,
	name tinytext,
  	description text,
  	type varchar(255) NOT NULL,
  	is_required tinyint(1) unsigned NOT NULL default 0,
  	is_random tinyint(1) unsigned NOT NULL default 0,
  	is_visible tinyint(1) unsigned NOT NULL default 0,
  	allowed_file_types text,
  	display_order INT(11) unsigned NOT NULL default 0,
	KEY surveys_id (surveys_id)
) CHARACTER SET=utf8mb4 ENGINE=INNODB';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%surveys_response (
  	id INT(11) unsigned NOT NULL auto_increment PRIMARY KEY,
  	surveys_id INT(11) unsigned NOT NULL default 0,
	subscriber_id INT(11) default NULL,
	stat_id INT(11) default NULL,
  	datetime datetime NOT NULL,
	KEY surveys_id (surveys_id)
) CHARACTER SET=utf8mb4 ENGINE=INNODB';


$queries[] = 'CREATE TABLE %%TABLEPREFIX%%surveys_response_value (
  	id INT(11) unsigned NOT NULL auto_increment PRIMARY KEY,
  	surveys_response_id INT(11) unsigned NOT NULL default 0,
  	surveys_widgets_id INT(11) unsigned NOT NULL default 0,
  	value text,
  	is_othervalue tinyint(1) unsigned NOT NULL default 0,
  	file_value varchar(64),
  	KEY surveys_response_id (surveys_response_id),
  	KEY surveys_widgets_id (surveys_widgets_id)
) CHARACTER SET=utf8mb4 ENGINE=INNODB';

$queries[] = 'INSERT INTO %%TABLEPREFIX%%surveys (userid, name, created, surveys_header_text, surveys_header_logo, email, show_message, show_uri, error_message, submit_button_text) VALUES 
	(1, "Reason for unsubscribing", UNIX_TIMESTAMP(), "Reason for unsubscribing", "", "admin@yourdomain.com", "Thanks for filling in our survey. Your opinion is important to us.", "http://", "Oops... something went wrong when trying to save your survey responses. Take a look at the errors below and try again.", "Submit Form");';
$queries[] = 'SET @survey_id = LAST_INSERT_ID();';

$queries[] = 'INSERT INTO %%TABLEPREFIX%%surveys_widgets (surveys_id, name, description, type, is_required, is_random, is_visible, allowed_file_types, display_order) VALUES 
	(@survey_id, "Please help understand why you are unsubscribing", "Please choose one:", "radio", 0, 0, 1, 0, 0);';
$queries[] = 'SET @widget_id = LAST_INSERT_ID();';

$queries[] = 'INSERT INTO %%TABLEPREFIX%%surveys_fields (surveys_widget_id, value, is_selected, is_other, other_label_text, display_order) VALUES
	(@widget_id, "I no longer want to receive these emails", 0, 0, "", 0),
	(@widget_id, "I am receiving these emails too often", 0, 0, "", 1),
	(@widget_id, "I never signed up for this mailing list", 0, 0, "", 2),
	(@widget_id, "The content is not relevant to me", 0, 0, "", 3),
	(@widget_id, "", 0, 1, "Other:", 4);';


// $queries[] = 'CREATE UNIQUE INDEX %%TABLEPREFIX%%surveys_response_value ON %%TABLEPREFIX%%surveys_response_value(surveys_response_id, surveys_widgets_id)';
// $queries[] = 'CREATE UNIQUE INDEX %%TABLEPREFIX%%split_stats_newsletters_split_news ON %%TABLEPREFIX%%splittest_statistics_newsletters(split_statid, newsletter_statid)';
