<?php
/**
 * Survey Model definition for all operation concering
 * the survey table..
 *
 * @author Yudi
 *
 */

class Addons_surveys_model_surveys extends Addons_surveys_model_base
{
	/**
	 * @var String $_tablename
	 */
	private $_tablename = 'surveys';

	/**
	 * Contains all data columns for the table
	 * 
	 * @var Array $_data
	 */
	protected $_data = [
		'name' => '',
		'description' => '',
		'created' => '',
		'email' => '',
		'email_feedback' => '',
		'after_submit' => '',
		'show_message' => '',
		'show_uri' => '',
		'error_message' => '',
		'submit_button_text' => ''
	];

	/**
	 * @var Mixed @id
	 */
	public $id = false;

	/**
	 * @param Mixed $form
	 */
	public function __construct($form) {
		parent::__construct();

		$this->setTableName();
	}

	/**
	 * @return Void
	 */
	private function setTableName() {
		$this->_tablename = $this->_tableprefix . $this->_tablename;
	}

	/**
	 * @return Array
	 */
	public function getTableKeys() {
		return (array_keys($this->_data));
	}

	/**
	 * @param Int|String $key
	 * @param Mixed $value
	 * 
	 * @return Void
	 */
	public function Set($key, $value) {
		if (!array_key_exists($key, $this->_data)) {

		}
		$this->_data[$key] = $value;
	}

	/**
	 * @param Int|String $key
	 * 
	 * @return Mixed
	 */
	public function Get($key) {
		if (array_key_exists($key, $this->_data)) {
			return $this->_data[$key];
		}

		return null;
	}

	/**
	 * @return Array
	 */
	public function GetAllData() {
		return $this->_data;
	}

	/**
	 * Get ID
	 * 	Returns the specific / current ID of what is currently in the table;
	 * 
	 * @return Mixed
	 */
	public function GetId() {
		return $this->id;
	}
}

?>