<?php

// an array of tables that are created.
// we need this so if the addon is uninstalled, we know what we need to clean up.
//$tables = ['splittest_campaigns', 'splittest_statistics', 'splittest_statistics_newsletters','splittests' ];
$tables = ['splittest_campaigns','splittest_statistics_newsletters','splittest_statistics', 'splittests' ];

// the actual queries we're going to run.
$queries = [];

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%splittests (
	splitid INT(11) NOT NULL AUTO_INCREMENT,
	splitname VARCHAR(200),
	splittype VARCHAR(100),
	splitdetails TEXT,
	createdate INT(11) DEFAULT 0,
	userid INT(11) DEFAULT 0,
	jobid INT(11) DEFAULT 0,
	jobstatus CHAR(1) DEFAULT NULL,
	lastsent INT(11) DEFAULT 0 ,
  PRIMARY KEY (splitid)
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%splittest_campaigns (
	splitid INT(11) DEFAULT 0,
	campaignid INT(11) DEFAULT 0,
	 FOREIGN KEY (splitid) REFERENCES %%TABLEPREFIX%%splittests(splitid) ON DELETE CASCADE ON UPDATE CASCADE
 
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%splittest_statistics (
	split_statid INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	splitid INT(11) NOT NULL DEFAULT 0,
	jobid INT(11) NOT NULL DEFAULT 0,
	starttime INT(11) NOT NULL DEFAULT 0,
	finishtime INT(11) NOT NULL DEFAULT 0,
	hiddenby INT(11) NOT NULL DEFAULT 0,
 FOREIGN KEY (jobid) REFERENCES %%TABLEPREFIX%%jobs(jobid) ON DELETE CASCADE ON UPDATE CASCADE,	 
 FOREIGN KEY (splitid) REFERENCES %%TABLEPREFIX%%splittests(splitid) ON DELETE CASCADE ON UPDATE CASCADE
 
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%splittest_statistics_newsletters (
	split_statid INT(11) NOT NULL DEFAULT 0 ,
	newsletter_statid INT(11) NOT NULL DEFAULT 0,
 FOREIGN KEY (split_statid) REFERENCES %%TABLEPREFIX%%splittest_statistics (split_statid) ON DELETE CASCADE ON UPDATE CASCADE,
 FOREIGN KEY (newsletter_statid) REFERENCES %%TABLEPREFIX%%stats_newsletters (statid) ON DELETE CASCADE ON UPDATE CASCADE
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

 //$queries[] = 'CREATE UNIQUE INDEX %%TABLEPREFIX%%split_campaigns_split_campaign ON %%TABLEPREFIX%%splittest_campaigns(splitid, campaignid)';
 //$queries[] = 'CREATE UNIQUE INDEX %%TABLEPREFIX%%split_stats_newsletters_split_news ON %%TABLEPREFIX%%splittest_statistics_newsletters(split_statid, newsletter_statid)';
